/******************************************************************************
* This file contains the declarations for different tables used in RF4CE Nwk.
*
* Copyright (c) 2008, Freescale, Inc.  All rights reserved.
*
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from  Freescale Semiconductor.
*
******************************************************************************/

#include "EmbeddedTypes.h"
#include "NwkInterface.h"
#include "NwkGlobals.h"
#include "ApplicationConf.h"
#include "NwkDeviceType.h"


/******************************************************************************
*******************************************************************************
* Private Macros
*******************************************************************************
******************************************************************************/

/******************************************************************************
*******************************************************************************
* Public memory declarations
*******************************************************************************
******************************************************************************/
/* Application defined value keeping the maximum number of entries in the pair 
   table. Do not modify this line of code. The number of entries in the pair 
   table should only be configured by changing the value of gMaxPairingTableEntries_c
   define in the NwkInterface.h file */
   
/* Number of pair tables entries supported by the local node */
CONST uint8_t nwkcMaxPairingTableEntries = gMaxPairingTableEntries_c;

/* Capabilities of the local node */
CONST uint8_t nwkcNodeCapabilities = (gDefaultValueOfNodeType_c                  << capabilitiesBitPosition_NodeType)    | 
                                     (gDefaultValueOfCapabPowerSource_c          << capabilitiesBitPosition_PowerSource) | 
                                     (gDefaultValueOfCapabSecurity_c             << capabilitiesBitPosition_Security)    |
                                     (gDefaultValueOfCapabChannelNormalization_c << capabilitiesBitPosition_ChannelNormalization);
  
/* VendorId of the local node */
CONST uint8_t       nwkcVendorId[2]                              = gDefaultValueOfVendorId_c;

/* Vendor string of the local node */
CONST uint8_t       nwkcVendorString[gSizeOfVendorString_c]      = gDefaultValueOfVendorString_c;

/* Frame counter window of the local node */
CONST  uint32_t     nwkcFrameCounterWindow  = gDefaultValueOfFrameCounterWindow_c;   

/* Node data containing the pairing table */
nodeData_t nodeData;

/* Nwk Nib Database */
nwkNib_t gNwkNib;

/* gMaxPairingTableEntries_c validation */
#if ((gDefaultValueOfNodeType_c == gNodeTypeController_c) && (gMaxPairingTableEntries_c < 1))
#error gMaxPairingTableEntries_c must be greater than 1.
#endif

#if ((gDefaultValueOfNodeType_c == gNodeTypeTarget_c) && (gMaxPairingTableEntries_c < 5))
#error According with the RF4CE standard, gMaxPairingTableEntries_c must be greater or at least equal to 5.
#endif

#ifdef PROCESSOR_MC1323X 
  #if (gMaxPairingTableEntries_c > 16)
  #error gMaxPairingTableEntries_c must be less or equal to 16.
  #endif
#else
  #if (gMaxPairingTableEntries_c > 8)
  #error gMaxPairingTableEntries_c must be less or equal to 8.
  #endif
#endif

/******************************************************************************
*******************************************************************************
* Private Macros
*******************************************************************************
******************************************************************************/
/****************************************************************************/

/* TaskIDs. The MAC library needs to know the IDs for some of the tasks, so
 * it can set events for them. But it is supplied as a binary library, so it
 * can't use #define or enum constants, and the TaskIDs might change. TaskIDs
 * are assigned dynamically by the kernel.
 * Instead, there is integer in RAM for each task that contains that task's
 * ID. This costs some RAM, but the MAC library only needs to know the names
 * of the integers, not the TaskIDs, at link time.
 */

#define Task( taskIdGlobal, taskInitFunc, taskMainFunc, priority ) \
  tsTaskID_t taskIdGlobal;

#include "NwkTasksTbl.h"


